/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers.string;

import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.ControllerWidget;
import dev.isxander.yacl.gui.controllers.string.IStringController;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class StringControllerElement
extends ControllerWidget<IStringController<?>> {
    protected StringBuilder inputField;
    protected Dimension<Integer> inputFieldBounds;
    protected boolean inputFieldFocused;
    protected int caretPos;
    protected int selectionLength;
    protected float ticks;
    private final class_2561 emptyText;

    public StringControllerElement(IStringController<?> control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
        this.inputField = new StringBuilder(control.getString());
        this.inputFieldFocused = false;
        this.selectionLength = 0;
        this.emptyText = class_2561.method_43470((String)"Click to type...").method_27692(class_124.field_1080);
        this.setDimension(dim);
    }

    @Override
    protected void drawHoveredControl(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.ticks += delta;
        class_332.method_25294((class_4587)matrices, (int)this.inputFieldBounds.x(), (int)this.inputFieldBounds.yLimit(), (int)this.inputFieldBounds.xLimit(), (int)(this.inputFieldBounds.yLimit() + 1), (int)-1);
        class_332.method_25294((class_4587)matrices, (int)(this.inputFieldBounds.x() + 1), (int)(this.inputFieldBounds.yLimit() + 1), (int)(this.inputFieldBounds.xLimit() + 1), (int)(this.inputFieldBounds.yLimit() + 2), (int)-12566464);
        if (this.inputFieldFocused || this.focused) {
            int caretX = this.inputFieldBounds.x() + this.textRenderer.method_1727(((IStringController)this.control).getString().substring(0, this.caretPos)) - 1;
            if (this.inputField.isEmpty()) {
                caretX += this.inputFieldBounds.width() / 2;
            }
            if (this.ticks % 20.0f <= 10.0f) {
                class_332.method_25294((class_4587)matrices, (int)caretX, (int)this.inputFieldBounds.y(), (int)(caretX + 1), (int)this.inputFieldBounds.yLimit(), (int)-1);
            }
            if (this.selectionLength != 0) {
                int selectionX = this.inputFieldBounds.x() + this.textRenderer.method_1727(((IStringController)this.control).getString().substring(0, this.caretPos + this.selectionLength));
                class_332.method_25294((class_4587)matrices, (int)caretX, (int)(this.inputFieldBounds.y() - 1), (int)selectionX, (int)this.inputFieldBounds.yLimit(), (int)-2144325377);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.inputFieldBounds.isPointInside((int)mouseX, (int)mouseY)) {
            if (!this.inputFieldFocused) {
                this.inputFieldFocused = true;
                this.caretPos = this.getDefaultCarotPos();
            } else {
                int textWidth = (int)mouseX - this.inputFieldBounds.x();
                this.caretPos = this.textRenderer.method_27523(((IStringController)this.control).getString(), textWidth).length();
                this.selectionLength = 0;
            }
            return true;
        }
        this.inputFieldFocused = false;
        return false;
    }

    protected int getDefaultCarotPos() {
        return this.inputField.length();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        switch (keyCode) {
            case 256: {
                this.inputFieldFocused = false;
                return true;
            }
            case 263: {
                if (class_437.method_25442()) {
                    if (class_437.method_25441()) {
                        int spaceChar = this.findSpaceIndex(true);
                        this.selectionLength += this.caretPos - spaceChar;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos > 0) {
                        --this.caretPos;
                        ++this.selectionLength;
                    }
                } else {
                    if (this.caretPos > 0) {
                        --this.caretPos;
                    }
                    this.selectionLength = 0;
                }
                return true;
            }
            case 262: {
                if (class_437.method_25442()) {
                    if (class_437.method_25441()) {
                        int spaceChar = this.findSpaceIndex(false);
                        this.selectionLength -= spaceChar - this.caretPos;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos < this.inputField.length()) {
                        ++this.caretPos;
                        --this.selectionLength;
                    }
                } else {
                    if (this.caretPos < this.inputField.length()) {
                        ++this.caretPos;
                    }
                    this.selectionLength = 0;
                }
                return true;
            }
            case 259: {
                this.doBackspace();
                return true;
            }
            case 261: {
                this.doDelete();
                return true;
            }
        }
        if (this.canUseShortcuts()) {
            if (class_437.method_25437((int)keyCode)) {
                this.write(this.client.field_1774.method_1460());
                return true;
            }
            if (class_437.method_25438((int)keyCode) && this.selectionLength != 0) {
                this.client.field_1774.method_1455(this.getSelection());
                return true;
            }
            if (class_437.method_25436((int)keyCode) && this.selectionLength != 0) {
                this.client.field_1774.method_1455(this.getSelection());
                this.write("");
                return true;
            }
            if (class_437.method_25439((int)keyCode)) {
                this.caretPos = this.inputField.length();
                this.selectionLength = -this.caretPos;
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        this.write(Character.toString(chr));
        return true;
    }

    protected boolean canUseShortcuts() {
        return true;
    }

    protected void doBackspace() {
        if (this.selectionLength != 0) {
            this.write("");
        } else if (this.caretPos > 0) {
            this.inputField.deleteCharAt(this.caretPos - 1);
            --this.caretPos;
            this.updateControl();
        }
    }

    protected void doDelete() {
        if (this.caretPos < this.inputField.length()) {
            this.inputField.deleteCharAt(this.caretPos);
            this.updateControl();
        }
    }

    public void write(String string) {
        if (this.selectionLength == 0) {
            string = this.textRenderer.method_27523(string, this.getMaxLength() - this.textRenderer.method_1727(this.inputField.toString()));
            this.inputField.insert(this.caretPos, string);
            this.caretPos += string.length();
        } else {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            string = this.textRenderer.method_27523(string, this.getMaxLength() - this.textRenderer.method_1727(this.inputField.toString()) + this.textRenderer.method_1727(this.inputField.substring(start, end)));
            this.inputField.replace(start, end, string);
            this.caretPos = start + string.length();
            this.selectionLength = 0;
        }
        this.updateControl();
    }

    public int getMaxLength() {
        return this.getDimension().width() / 8 * 7;
    }

    public int getSelectionStart() {
        return Math.min(this.caretPos, this.caretPos + this.selectionLength);
    }

    public int getSelectionEnd() {
        return Math.max(this.caretPos, this.caretPos + this.selectionLength);
    }

    protected String getSelection() {
        return this.inputField.substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    protected int findSpaceIndex(boolean reverse) {
        int i;
        int fromIndex = this.caretPos;
        if (reverse) {
            if (this.caretPos > 0) {
                --fromIndex;
            }
            if ((i = this.inputField.lastIndexOf(" ", fromIndex)) == -1) {
                i = 0;
            }
        } else {
            if (this.caretPos < this.inputField.length()) {
                ++fromIndex;
            }
            if ((i = this.inputField.indexOf(" ", fromIndex)) == -1) {
                i = this.inputField.length();
            }
        }
        return i;
    }

    @Override
    public boolean method_25407(boolean lookForwards) {
        this.inputFieldFocused = super.method_25407(lookForwards);
        return this.inputFieldFocused;
    }

    @Override
    public void unfocus() {
        super.unfocus();
        this.inputFieldFocused = false;
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int width = Math.max(6, this.textRenderer.method_27525((class_5348)this.getValueText()));
        int n = dim.xLimit() - this.getXPadding() - width;
        int n2 = dim.centerY();
        Objects.requireNonNull(this.textRenderer);
        int n3 = n2 - 9 / 2;
        Objects.requireNonNull(this.textRenderer);
        this.inputFieldBounds = Dimension.ofInt(n, n3, width, 9);
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.inputFieldFocused;
    }

    protected void updateControl() {
        ((IStringController)this.control).setFromString(this.inputField.toString());
    }

    @Override
    protected int getHoveredControlWidth() {
        return this.getUnhoveredControlWidth();
    }

    @Override
    protected class_2561 getValueText() {
        if (!this.inputFieldFocused && this.inputField.isEmpty()) {
            return this.emptyText;
        }
        return super.getValueText();
    }
}

